-- events for ui screen

T_LOCKED = Localize ("Locked!");
T_HOW_TO_UNLOCK_SURVIVAL = Localize ("Discover at least one Talisman to unlock Survival game mode.");

function OnLoad ()
	SetProperty ("/:enter_trans_duration", 0.3);
	SetProperty ("/:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
end;


function OnEnter ()
	timer = 0;

	PlaySound ("ui/sfx/panel_move.ogg");
end;

function OnLeave ()
	--RemoveProfileVar ("SurvivalTalisman");
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Back") then
	    	PlaySound ("ui/sfx/panel_move.ogg");
		PopScreen ();
		return;
	end;
	
	
	-- if any of the play buttons were pressed, set and start the game
	if (name == "PlayQuest") then
		
		-- set the active game mode
		num = GetGameByName ("AzkendQuestMode");
		Print ("Game Num is " .. num .. "\n");
		
		if (num == -1) then
			return;
		end;
		
		SetGame (num);	
		SetVar ("GameMode", "QUEST");
		Azkend_SetGameMode (GetVar ("GameMode"));

		
		if (IsSaveGameFileAvailable ()) then
			PushScreen ("ContinueOldGame");
		else
			InitNewGame ();
			local value = GetProfileVar ("GameCompleted");
			if (not (value == nil) and not (value == "0")) then
				SetGameLevel (2);
				SwitchScreen ("WorldMap");
			else
				SetGameLevel (1);
				SwitchScreen ("StoryIntro");
			end;
		end;
	end;
	
	
	if (name == "PlaySurvival") then
		num_unlocked = Azkend_GetNumTalismansUnlocked ();
		if (num_unlocked < 1) then
			SetProperty ("/InfoPopup/title:label.text", T_LOCKED);
			SetProperty ("/InfoPopup/text:label.text", T_HOW_TO_UNLOCK_SURVIVAL);
			PushScreen ("InfoPopup");		
		else
			-- set the active game mode
			num = GetGameByName ("AzkendSurvivalMode");
			Print ("Game Num is " .. num .. "\n");
			
			if (num == -1) then
				return;
			end;
			
			SetGame (num);	
			SetVar ("GameMode", "SURVIVAL");
			Azkend_SetGameMode (GetVar ("GameMode"));
	
			
			if (IsSaveGameFileAvailable ()) then
				PushScreen ("ContinueOldGame");
			else
				SwitchScreen ("SurvivalMode");
			end;
		end;
	end;	
	
end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	timer = timer + tdelta;
	
	num_unlocked = Azkend_GetNumTalismansUnlocked ();
	if (num_unlocked > 0 and not IsSetProfileVar ("SurvivalTalisman") and timer >= 0.6) then
		SetProfileVar ("SurvivalTalisman", "Amulet_JadeBomb");
		local x = GetProperty ("survival_lock:static_position.x");
		local y = GetProperty ("survival_lock:static_position.y");
		SpawnFX ("fxs/button-lock-breaks.lua", x, y, 0, 0);
	end;
	
	
	if (IsSetProfileVar ("SurvivalTalisman")) then
		SetProperty ("survival_lock:visible", 0);
	else
		SetProperty ("survival_lock:visible", 1);
	end;
	
	
	
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
	
	a = GetProperty ("PlayQuest:time_cursor_over");
	SetProperty ("QuestDesc:alpha", trans * a);
	SetProperty ("PlayAdventureImage:alpha", trans * a);

	b = GetProperty ("PlaySurvival:time_cursor_over");
	SetProperty ("SurvivalDesc:alpha", trans * b);
	SetProperty ("PlaySurvivalImage:alpha", trans * b);
	
	c = 1-math.max(a,b)
	SetProperty ("Tip:alpha", trans * c);
	SetProperty ("PlayNoneImage:alpha", trans * c);
	
end;

function OnDraw ()

end;
